/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.regionalsettings.FormatterRegionSettings;
import cz.insophy.inplan.util.regionalsettings.RegionalSettings;
import cz.insophy.inplan.util.regionalsettings.XmlRegionalSettings;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Formatter {
    private static final Logger log = LoggerFactory.getLogger(Formatter.class);
    private static final String DEFAULT_REGION_ID = "cs";
    private static final ThreadLocal<String> regionId = ThreadLocal.withInitial(() -> "cs");
    private static Map<String, FormatterRegionSettings> formats = Formatter.regionsToFormats(new RegionalSettings().createLegacyRegions());

    private Formatter() {
        throw new UnsupportedOperationException();
    }

    public static void setRegions(@Nonnull XmlRegionalSettings regions) {
        Preconditions.checkNotNull(regions);
        Preconditions.checkState(!regions.getRegion().isEmpty(), "Regional settings must contain at least one region!");
        formats = Formatter.regionsToFormats(regions);
        if (!formats.containsKey(DEFAULT_REGION_ID)) {
            throw new IllegalStateException("Missing default region \"cs\" settings.");
        }
    }

    @Nonnull
    private static Map<String, FormatterRegionSettings> regionsToFormats(XmlRegionalSettings regions) {
        return regions.getRegion().stream().collect(Collectors.toMap(XmlRegionalSettings.Region::getId, FormatterRegionSettings::new));
    }

    public static void setRegionId(@Nonnull String newRegionId) {
        Preconditions.checkState(!Strings.isNullOrEmpty(newRegionId) && !newRegionId.isBlank());
        if (!newRegionId.equals(regionId.get())) {
            if (!formats.containsKey(newRegionId)) {
                log.error("Unable to set Region id=\"{}\", region not found. Settings defaulting to \"{}\"", (Object)newRegionId, (Object)DEFAULT_REGION_ID);
                regionId.set(DEFAULT_REGION_ID);
            } else {
                regionId.set(newRegionId);
            }
        }
    }

    public static String getRegionId() {
        return regionId.get();
    }

    public static FormatterRegionSettings getFormats() {
        return formats.get(regionId.get());
    }

    public static XmlRegionalSettings.Region.Symbols getSymbols() {
        return Formatter.getFormats().getSymbols();
    }

    public static String formatBoolean(Boolean value) {
        if (value == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return value != false ? Formatter.getSymbols().getBooleanTrue() : Formatter.getSymbols().getBooleanFalse();
    }

    @Nonnull
    public static String formatNumber(@Nullable Number value) {
        if (value == null) {
            return Formatter.getSymbols().getUndefined();
        }
        if (Double.isNaN(value.doubleValue())) {
            return Formatter.getSymbols().getNotANumber();
        }
        return Formatter.formatGenericNumber(Formatter.getFormats().getNumberFormat(), value.doubleValue());
    }

    public static String formatPercent(double ratio) {
        if (Double.isInfinite(ratio) || Double.isNaN(ratio)) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.formatGenericNumber(Formatter.getFormats().getPercentFormat(), ratio);
    }

    private static String formatGenericNumber(DecimalFormat format, double value) {
        int multiplier = format.getMultiplier();
        if ((double)multiplier * Math.abs(value) < Math.pow(10.0, -format.getMaximumFractionDigits()) / 2.0) {
            return format.format(0L);
        }
        return format.format(value);
    }

    public static String formatShortDate(long date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getShortDateFormat());
    }

    public static String formatShortDate(@Nullable LocalDate date) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.getFormats().getShortDateFormat().format(date);
    }

    public static String formatLongDate(@Nullable LocalDate date) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.getFormats().getLongDateFormat().format(date);
    }

    public static String formatShortDateTime(long date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getShortDatetimeFormat());
    }

    public static String formatMediumDateTime(@Nullable LocalDateTime date) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.getFormats().getMediumDatetimeFormat().format(date);
    }

    public static String formatMediumDateTime(long date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getMediumDatetimeFormat());
    }

    @Nonnull
    public static String formatShortDateTime(@Nullable LocalDateTime date) {
        if (date == null || !GeneralizedRequest.isDateValid(date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.getFormats().getShortDatetimeFormat().format(date);
    }

    @Deprecated
    @Nonnull
    public static String formatShortDateTime(@Nullable Date date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getShortDatetimeFormat());
    }

    public static String formatMediumDate(long date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getMediumDateFormat());
    }

    @Deprecated
    @Nonnull
    public static String formatMediumDate(@Nullable Date date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getMediumDateFormat());
    }

    @Nonnull
    public static String formatMediumDate(@Nullable LocalDate date) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.getFormats().getMediumDateFormat().format(date);
    }

    @Deprecated
    @Nonnull
    public static String formatMediumDateTime(@Nullable Date date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getMediumDatetimeFormat());
    }

    public static String formatLongDateTime(long date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getLongDatetimeFormat());
    }

    @Nonnull
    public static String formatLongDateTime(@Nullable LocalDateTime date) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return date.format(Formatter.getFormats().getLongDatetimeFormat());
    }

    @Deprecated
    @Nonnull
    public static String formatLongDateTime(@Nullable Date date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getLongDatetimeFormat());
    }

    public static String formatFileDate(@Nonnull LocalDateTime date) {
        Preconditions.checkNotNull(date);
        return date.format(Formatter.getFormats().getFileDateFormat());
    }

    public static String formatTime(long millis) {
        return Formatter.genericFormat(millis, Formatter.getFormats().getTimeFormat());
    }

    public static String formatTime(@Nullable LocalTime time) {
        if (time == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return time.format(Formatter.getFormats().getTimeFormat());
    }

    @Deprecated
    @Nonnull
    public static String formatTime(@Nullable Date date) {
        return Formatter.genericFormat(date, Formatter.getFormats().getTimeFormat());
    }

    public static String formatUserTime(String pattern, long date) {
        DateTimeFormatter format = Formatter.getFormats().getUserDatetimeFormat(pattern);
        return Formatter.genericFormat(date, format);
    }

    private static String genericFormat(long millis, DateTimeFormatter format) {
        if (!GeneralizedRequest.isDateValid(millis)) {
            return Formatter.getSymbols().getUndefined();
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(format);
    }

    @Nonnull
    private static String genericFormat(@Nullable Date date, @Nonnull DateTimeFormatter format) {
        if (date == null) {
            return Formatter.getSymbols().getUndefined();
        }
        return Formatter.genericFormat(date.getTime(), format);
    }

    public static String formatDuration(long duration) {
        return Formatter.formatDuration(duration, false);
    }

    public static String formatDurationCompact(long duration) {
        return Formatter.formatDuration(duration, true);
    }

    private static String formatDuration(long duration, boolean compact) {
        String sign;
        XmlRegionalSettings.Region.Symbols symbols = Formatter.getSymbols();
        DurationParts parts = Formatter.splitDuration(duration);
        if (parts == null) {
            return symbols.getUndefined();
        }
        if (parts.days() != 0L) {
            if (parts.hours() == 0L && parts.minutes() == 0L) {
                return String.format("%d %s", parts.days(), symbols.getDays());
            }
            if (compact) {
                return String.format("%d %s %02d %s", parts.days(), Formatter.getSymbols().getDays(), parts.hours(), Formatter.getSymbols().getHours());
            }
            return String.format("%d %s %02d %s %02d %s", parts.days(), symbols.getDays(), parts.hours(), symbols.getHours(), parts.minutes(), symbols.getMinutesShort());
        }
        String string = sign = parts.negative() ? "-" : "";
        if (parts.hours() == 0L) {
            if (parts.minutes() == 0L) {
                if (parts.seconds() == 0L) {
                    if (parts.milliseconds() == 0L) {
                        return "0";
                    }
                    return String.format("< %s1 %s", sign, symbols.getSeconds());
                }
                if (compact) {
                    return String.format("< %s1 %s", sign, symbols.getMinutes());
                }
                return String.format("%s%02d %s", sign, parts.seconds(), symbols.getSeconds());
            }
            if (parts.seconds() == 0L || compact) {
                return String.format("%s%02d %s", sign, parts.minutes(), symbols.getMinutes());
            }
            return String.format("%s%02d %s %02d %s", sign, parts.minutes(), symbols.getMinutes(), parts.seconds(), symbols.getSeconds());
        }
        return String.format("%s%02d %s %02d %s", sign, parts.hours(), symbols.getHours(), parts.minutes(), symbols.getMinutesShort());
    }

    public static String formatDetailDuration(long duration) {
        DurationParts parts = Formatter.splitDuration(duration);
        if (parts == null) {
            return Formatter.getSymbols().getUndefined();
        }
        String sign = parts.negative() ? "-" : "";
        String days = parts.days() > 0L ? parts.days() + Formatter.getSymbols().getDays() + " " : "";
        return String.format("%s%s%02d:%02d:%02d.%03d", sign, days, parts.hours(), parts.minutes(), parts.seconds(), parts.milliseconds());
    }

    @Nullable
    private static DurationParts splitDuration(long duration) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return null;
        }
        boolean negative = duration < 0L;
        long remains = Math.abs(duration);
        long days = remains / 86400000L;
        long hours = (remains %= 86400000L) / 3600000L;
        long minutes = (remains %= 3600000L) / 60000L;
        long seconds = (remains %= 60000L) / 1000L;
        long milliseconds = remains % 1000L;
        return new DurationParts(negative, days, hours, minutes, seconds, milliseconds);
    }

    public static String formatDurationDay(long duration) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Formatter.getSymbols().getUndefined();
        }
        double days = (double)duration / 8.64E7;
        return (Formatter.getFormats().getNumberDurationFormat().format(days) + " " + Formatter.getSymbols().getDays()).trim();
    }

    public static String formatDurationRangeDay(long from, long to) {
        if (!GeneralizedRequest.isDateValid(from)) {
            return Formatter.getSymbols().getUndefined();
        }
        if (!GeneralizedRequest.isDateValid(to)) {
            return Formatter.getSymbols().getUndefined();
        }
        double daysFrom = (double)from / 8.64E7;
        double daysTo = (double)to / 8.64E7;
        return (Formatter.getFormats().getNumberDurationFormat().format(daysFrom) + " - " + Formatter.getFormats().getNumberDurationFormat().format(daysTo) + " " + Formatter.getSymbols().getDays()).trim();
    }

    private static String formatDuration(long duration, long unit, String unitString) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Formatter.getSymbols().getUndefined();
        }
        double hours = (double)duration / (double)unit;
        return (Formatter.getFormats().getNumberDurationFormat().format(hours) + " " + unitString).trim();
    }

    public static String formatNh(int hours) {
        return hours + " " + Formatter.getSymbols().getNormoHour();
    }

    public static String formatNh(double hours) {
        return Formatter.formatNumber(hours) + " " + Formatter.getSymbols().getNormoHour();
    }

    public static String formatDurationNh(long duration) {
        return Formatter.formatDuration(duration, 3600000L, Formatter.getSymbols().getNormoHour());
    }

    public static String formatDurationNh(double duration) {
        return Formatter.formatNumber(duration) + " " + Formatter.getSymbols().getNormoHour();
    }

    public static String formatDurationHour(long duration) {
        return Formatter.formatDuration(duration, 3600000L, Formatter.getSymbols().getHours());
    }

    public static String formatDurationRangeNh(double from, double to) {
        String fromTxt = Formatter.formatNumber(from);
        String toTxt = Formatter.formatNumber(to);
        return (fromTxt + " - " + toTxt + " " + Formatter.getSymbols().getNormoHour()).trim();
    }

    public static String formatQty(double qty) {
        return Formatter.formatNumber(qty) + " " + Formatter.getSymbols().getQuantity();
    }

    private record DurationParts(boolean negative, long days, long hours, long minutes, long seconds, long milliseconds) {
    }

    public static enum DateFormat {
        SHORT("short"),
        MEDIUM("medium"),
        LONG("long");

        private final String value;

        private DateFormat(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DateFormat fromValue(@Nullable String v) {
            if (v == null) {
                return null;
            }
            if (v.isBlank()) {
                return MEDIUM;
            }
            for (DateFormat c : DateFormat.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum DurationStyle {
        NORMAL("normal"),
        DETAIL("detail"),
        COMPACT("compact"),
        DAY_HOUR("day-hour"),
        DAY("day"),
        HOUR("hour"),
        NH("nh");

        private final String value;

        private DurationStyle(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DurationStyle fromValue(@Nullable String v) {
            if (v == null) {
                return null;
            }
            if (v.isBlank()) {
                return NORMAL;
            }
            for (DurationStyle c : DurationStyle.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

